
#ifndef _1_KMNG_EXT_ATP_TST_KeysOp_h_H
#define _1_KMNG_EXT_ATP_TST_KeysOp_h_H

/*
 * All the includes that are needed for code using this module to
 * compile correctly should be #included here.
 */
#include "DX_VOS_BaseTypes.h"
#include "KMNG_ATP_TST_Defines.h"
#include "KMNG_Defs.h"
#include "CRYS_AES.h"
#include "CRYS_DES.h"
#include "CRYS_HASH.h"
#include "CRYS_RSA_Types.h"
#include "KMNG_TST_Utils.h"


#ifdef __cplusplus
extern "C"
{
#endif


  /*
   *  Object %name    : %
   *  State           :  %state%
   *  Creation date   :  Mon Jul 30 10:18:14 2004
   *  Last modified   :  %modify_time%
   */
  /** @file
   *  \brief A brief description of this module
   *
   *  \version KMNG_ATP_TST_KeysOp.h#1:incl:1
   *  \author NogaD
   *  \remarks Copyright (C) 2007 by Discretix Technologies Ltd.
   *           All Rights reserved
   */


  /************************ Defines *******************************/

//#define TST_KMNG_LESS_DATA_FOR_PKCS1V15_ENCRYPT	    11 
//#define TST_KMNG_LESS_DATA_FOR_OAEP_ENCRYPT_SHA1	  42
//#define TST_KMNG_LESS_DATA_FOR_OAEP_ENCRYPT_SHA224	58
//#define TST_KMNG_LESS_DATA_FOR_OAEP_ENCRYPT_SHA256	66
//#define TST_KMNG_LESS_DATA_FOR_OAEP_ENCRYPT_SHA384	98
//#define TST_KMNG_LESS_DATA_FOR_OAEP_ENCRYPT_SHA512	130

  /************************ Enums *********************************/
  /************************ Typedefs  *****************************/
  /************************ Structs  ******************************/

	/* Context key data structure for symmetric (AES and HMAC) keys */
	typedef struct TST_Ext_KeysSym_TestDataStruct{	
		DxChar		    		    TST_Name[TST_NAME_STRING_LEN];
		DxUint8_t                   TST_Pwd[TST_KMNG_PWD_MAX_LEN];
		DxUint32_t                  TST_PwdLen;
		DxUint8_t                   TST_KeyPwd[TST_KMNG_PWD_MAX_LEN];
		DxUint32_t                  TST_KeyPwdLen;
		DxUint32_t                  TST_KeyID;
		KMNG_KeyType_t              TST_KeyType;
		DxUint32_t                  TST_KeyUsage;
		DxUint32_t                  TST_KeyRestriction;
		DxUint8_t                   TST_key[TST_KMNG_SYM_KEY_MAX_SIZE];
		DxUint32_t                  TST_KeySize;
		DxUint8_t                   TST_Exportedkey[TST_KMNG_SYM_KEY_MAX_SIZE];
		CRYS_AES_IvCounter_t        TST_IV;
		CRYS_AES_OperationMode_t    TST_AESMode;
		CRYS_DES_OperationMode_t    TST_DESMode;
		CRYS_HASH_OperationMode_t   TST_HASHMode;
		DxUint8_t                   TST_Data[TST_KMNG_MAX_SIZE_DATA];
		DxUint32_t                  TST_DataLen;
		DxUint8_t                   TST_ExpectedOutput[TST_KMNG_MAX_SIZE_DATA];
		DxUint8_t                   TST_OutputData[TST_KMNG_MAX_SIZE_DATA];
		DxUint32_t                  TST_OutputLen;
		DxUint8_t                   TST_VerifyOutput;
		KMNG_UserSpecificKeyData_t  TST_UserData;

	} TST_Ext_KeysSym_TestDataStruct;

  ///* Context key data structure for symmetric (AES and HMAC) keys */
  //typedef struct TST_KeysSym_TestDataStruct{	
  //  DxChar		    		    TST_Name[TST_NAME_STRING_LEN];
  //  DxUint8_t                   TST_Pwd[TST_KMNG_PWD_MAX_LEN];
  //  DxUint32_t                  TST_PwdLen;
  //  DxUint8_t                   TST_KeyPwd[TST_KMNG_PWD_MAX_LEN];
  //  DxUint32_t                  TST_KeyPwdLen;
  //  DxUint32_t                  TST_KeyID;
  //  KMNG_KeyType_t              TST_KeyType;
  //  DxUint32_t                  TST_KeyUsage;
  //  DxUint32_t                  TST_KeyRestriction;
  //  DxUint8_t                   TST_key[TST_KMNG_SYM_KEY_MAX_SIZE];
  //  DxUint32_t                  TST_KeySize;
  //  DxUint8_t                   TST_Exportedkey[TST_KMNG_SYM_KEY_MAX_SIZE];
  //  CRYS_AES_IvCounter_t        TST_IV;
  //  CRYS_AES_OperationMode_t    TST_AESMode;
  //  CRYS_DES_OperationMode_t    TST_DESMode;
  //  CRYS_HASH_OperationMode_t   TST_HASHMode;
  //  DxUint8_t                   TST_Data[TST_KMNG_MAX_SIZE_DATA];
  //  DxUint32_t                  TST_DataLen;
  //  DxUint8_t                   TST_ExpectedOutput[TST_KMNG_MAX_SIZE_DATA];
  //  DxUint8_t                   TST_OutputData[TST_KMNG_MAX_SIZE_DATA];
  //  DxUint32_t                  TST_OutputLen;
  //  DxUint8_t                   TST_VerifyOutput;
  //  KMNG_UserSpecificKeyData_t  TST_UserData;

  //} TST_KeysSym_TestDataStruct;

  ///* Context key data structure for RSA keys */
  //typedef struct TST_KeysRSA_TestDataStruct{	
  //  DxChar		    		    TST_Name[TST_NAME_STRING_LEN];
  //  DxUint8_t                   TST_Pwd[TST_KMNG_PWD_MAX_LEN];
  //  DxUint32_t                  TST_PwdLen;
  //  DxUint8_t                   TST_KeyPwd[TST_KMNG_PWD_MAX_LEN];
  //  DxUint32_t                  TST_KeyPwdLen;
  //  DxUint32_t                  TST_KeyID;
  //  KMNG_KeyType_t              TST_KeyType;
  //  DxUint32_t                  TST_KeyUsage;
  //  DxUint32_t                  TST_KeyRestriction;
  //  DxUint32_t                  TST_KeySize;
  //  CRYS_PKCS1_version		    TST_PKCS1_ver;
  //  CRYS_RSA_HASH_OpMode_t      TST_HASHMode;
  //  DxUint8_t                   TST_E[TST_KMNG_PWD_MAX_LEN];
  //  DxUint32_t                  TST_ESize;
  //  DxUint8_t                   TST_ExportedE[TST_KMNG_PWD_MAX_LEN];
  //  DxUint32_t                  TST_ExportedESize;
  //  DxUint8_t                   TST_N[TST_KMNG_MAX_RSA_PARAM_SIZE];
  //  DxUint32_t                  TST_NSize;
  //  DxUint8_t                   TST_ExportedN[TST_KMNG_MAX_RSA_PARAM_SIZE];
  //  DxUint32_t                  TST_ExportedNSize;  
  //  DxUint8_t                   TST_D[TST_KMNG_MAX_RSA_PARAM_SIZE];
  //  DxUint32_t                  TST_DSize;
  //  DxUint8_t                   TST_ExportedD[TST_KMNG_MAX_RSA_PARAM_SIZE];
  //  DxUint32_t                  TST_ExportedDSize;
  //  DxUint8_t                   TST_Data[TST_KMNG_MAX_SIZE_DATA];
  //  DxUint16_t                  TST_DataLen;
  //  DxUint8_t                   TST_ExpectedOutput[TST_KMNG_MAX_SIZE_DATA];
  //  DxUint16_t                  TST_OutputLen;
  //  DxUint8_t                   TST_VerifyOutput;
  //  KMNG_UserSpecificKeyData_t  TST_UserData;
  //} TST_KeysRSA_TestDataStruct;  

  ///* Context data structure for RSA Keys HASH */
  //typedef struct TST_KeysRSAHASHData_TestDataStruct{	
  //  DxUint8_t                 TST_MD5Data[TST_KMNG_MD5_OUTPUT_SIZE];  
  //  DxUint8_t                 TST_SHA1Data[TST_KMNG_SHA1_OUTPUT_SIZE];
  //  DxUint8_t                 TST_SHA224Data[TST_KMNG_SHA224_OUTPUT_SIZE];
  //  DxUint8_t                 TST_SHA256Data[TST_KMNG_SHA256_OUTPUT_SIZE];
  //  DxUint8_t                 TST_SHA384Data[TST_KMNG_SHA384_OUTPUT_SIZE];
  //  DxUint8_t                 TST_SHA512Data[TST_KMNG_SHA512_OUTPUT_SIZE];
  //} TST_KeysRSAHASHData_TestDataStruct;

  ///* Context key data structure for DH keys */
  //typedef struct TST_KeysDHData_TestDataStruct{
	 // DxChar		    		          TST_Name[TST_NAME_STRING_LEN];
	 // DxUint8_t                   TST_Pwd[TST_KMNG_PWD_MAX_LEN];
	 // DxUint32_t                  TST_PwdLen;
	 // DxUint8_t                   TST_KeyPwd[TST_KMNG_PWD_MAX_LEN];
	 // DxUint32_t                  TST_KeyPwdLen;
	 // DxUint32_t                  TST_KeyID;
	 // KMNG_KeyType_t              TST_KeyType;
	 // DxUint32_t                  TST_KeyUsage;
	 // DxUint32_t                  TST_KeyRestriction;
	 // DxUint32_t                  TST_KeySize;
	 // DxUint8_t					          TST_P[TST_KMNG_MAX_DH_PARAM_SIZE];
	 // DxUint16_t				          TST_PSize;
	 // DxUint8_t					          TST_ExportedP[TST_KMNG_MAX_DH_PARAM_SIZE];
	 // DxUint32_t				          TST_ExportedPSize;
	 // DxUint8_t       					  TST_G[TST_KMNG_MAX_DH_PARAM_SIZE];
	 // DxUint16_t			        	  TST_GSize;
	 // DxUint8_t       					  TST_ExportedG[TST_KMNG_MAX_DH_PARAM_SIZE];
	 // DxUint32_t			        	  TST_ExportedGSize;
	 // DxUint8_t					          TST_PubKey[TST_KMNG_MAX_DH_PARAM_SIZE];
	 // DxUint32_t				          TST_PubKeySize;
	 // DxUint8_t					          TST_ExportedPubKey[TST_KMNG_MAX_DH_PARAM_SIZE];
	 // DxUint32_t				          TST_ExportedPubKeySize;
	 // DxUint8_t					          TST_PrivateKey[TST_KMNG_MAX_DH_PARAM_SIZE];
	 // DxUint32_t				          TST_PrivateKeySize;
	 // DxUint8_t					          TST_ExportedPrivateKey[TST_KMNG_MAX_DH_PARAM_SIZE];
	 // DxUint32_t				          TST_ExportedPrivateKeySize;
	 // DxUint16_t				          TST_L;
	 // DxUint8_t					          TST_SecretKey[TST_KMNG_MAX_DH_PARAM_SIZE];
	 // DxUint8_t					          TST_ServerSecretKey[TST_KMNG_MAX_DH_PARAM_SIZE];
	 // DxUint8_t                   TST_VerifyOutput;
	 // KMNG_UserSpecificKeyData_t  TST_UserData;
  //}TST_KeysDHData_TestDataStruct;

  ///* Data struct for DH server public and private key */
  //typedef struct TST_KeyDHServerData_Struct{
  //    DxUint8_t         TST_ServerPubKey[TST_KMNG_MAX_DH_PARAM_SIZE];
  //    DxUint16_t        TST_ServerPubKeySize;
  //    DxUint8_t         TST_ServerPrivKey[TST_KMNG_MAX_DH_PARAM_SIZE];
  //    DxUint16_t        TST_ServerPrivKeySize;
  //}TST_KeyDHServerData_Struct;

  ///************************ Global Data ***************************/

  ///* A buffer to contain the key ring */
  //extern DxUint32_t TST_KeyRing_Buf[KMNG_TST_MAX_SIZE_KEY_RING_BUF];

/************************ Public Variables **********************/
/************************ Public Functions **********************/

/*****************************************************************************
 * Function Name:                                                           
 *  KMNG_ATP_TST_KeysOperation      
 *  
 * Inputs:
 *  None
 *
 * Outputs: 
 *  CRYSError_t - Function error return                                     
 *
 * Description:                                                                 
 *  This function Is an acceptance test for Key management API's. The function 
 *  tests the operations on keys.
 *  
 * Algorithm:       
 * 1. Initialize a keys ring
 * 2. Create and import symmetric and RSA keys
 * 3. Activate and use each of the keys
 * 4. Export and verify each of the keys
 * 
 *  * Implements KMNG ATP section 5.2 
 *
 ******************************************************************************/                                
DxError_t SEP_KMNG_ATP_Ext_KeysOperation( void );

DxError_t SEP_KMNG_ATP_Ext_AESActivateOperation( void );

DxError_t SEP_KMNG_ATP_Ext_AESImportExportSymKeys( void );

DxError_t SEP_KMNG_ATP_Ext_DESImportExportSymKeys( void );

DxError_t SEP_KMNG_ATP_Ext_DESActivateOperation( void );

DxError_t SEP_KMNG_ATP_Ext_HMACImportExportSymKeys( void );

DxError_t SEP_KMNG_ATP_Ext_RSAImportExportSymKeys( void );

DxError_t SEP_KMNG_ATP_Ext_DHImportExportSymKeys( void );


#ifdef __cplusplus
}
#endif

#endif
